/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.debug.MessageConsumer;

public class Serial
implements SerialPortEventListener {
    SerialPort port;
    int rate;
    int parity;
    int databits;
    int stopbits;
    boolean monitor = false;
    InputStream input;
    OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    MessageConsumer consumer;

    public Serial(boolean monitor) throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
        this.monitor = monitor;
    }

    public Serial() throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(int irate) throws SerialException {
        this(Preferences.get("serial.port"), irate, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String iname, int irate) throws SerialException {
        this(iname, irate, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String iname) throws SerialException {
        this(iname, Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String iname, int irate, char iparity, int idatabits, float istopbits) throws SerialException {
        this.rate = irate;
        this.parity = 0;
        if (iparity == 'E') {
            this.parity = 2;
        }
        if (iparity == 'O') {
            this.parity = 1;
        }
        this.databits = idatabits;
        this.stopbits = 1;
        if (istopbits == 1.5f) {
            this.stopbits = 3;
        }
        if (istopbits == 2.0f) {
            this.stopbits = 2;
        }
        try {
            this.port = new SerialPort(iname);
            this.port.openPort();
            this.port.setParams(this.rate, this.databits, this.stopbits, this.parity, true, true);
            this.port.addEventListener(this);
        }
        catch (Exception e) {
            throw new SerialException(MessageFormat.format("Error opening serial port ''{0}''.", iname), e);
        }
        if (this.port == null) {
            throw new SerialException("Serial port '" + iname + "' not found.  Did you select the right one from the Tools > Serial Port menu?");
        }
    }

    public void setup() {
    }

    public void dispose() throws IOException {
        if (this.port != null) {
            try {
                if (this.port.isOpened()) {
                    this.port.closePort();
                }
            }
            catch (SerialPortException e) {
                throw new IOException(e);
            }
            finally {
                this.port = null;
            }
        }
    }

    public void addListener(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public synchronized void serialEvent(SerialPortEvent serialEvent) {
        if (serialEvent.isRXCHAR()) {
            try {
                byte[] buf = this.port.readBytes(serialEvent.getEventValue());
                if (buf.length > 0) {
                    if (this.bufferLast == this.buffer.length) {
                        byte[] temp = new byte[this.bufferLast << 1];
                        System.arraycopy(this.buffer, 0, temp, 0, this.bufferLast);
                        this.buffer = temp;
                    }
                    if (this.monitor) {
                        System.out.print(new String(buf));
                    }
                    if (this.consumer != null) {
                        this.consumer.message(new String(buf));
                    }
                }
            }
            catch (SerialPortException e) {
                Serial.errorMessage("serialEvent", e);
            }
        }
    }

    public synchronized int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public synchronized void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    public synchronized int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        int outgoing = this.buffer[this.bufferIndex++] & 0xFF;
        if (this.bufferIndex == this.bufferLast) {
            this.bufferIndex = 0;
            this.bufferLast = 0;
        }
        return outgoing;
    }

    public synchronized char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    public synchronized byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        int length = this.bufferLast - this.bufferIndex;
        byte[] outgoing = new byte[length];
        System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
        this.bufferIndex = 0;
        this.bufferLast = 0;
        return outgoing;
    }

    public synchronized int readBytes(byte[] outgoing) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        int length = this.bufferLast - this.bufferIndex;
        if (length > outgoing.length) {
            length = outgoing.length;
        }
        System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
        this.bufferIndex += length;
        if (this.bufferIndex == this.bufferLast) {
            this.bufferIndex = 0;
            this.bufferLast = 0;
        }
        return length;
    }

    public synchronized byte[] readBytesUntil(int interesting) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte what = (byte)interesting;
        int found = -1;
        for (int k = this.bufferIndex; k < this.bufferLast; ++k) {
            if (this.buffer[k] != what) continue;
            found = k;
            break;
        }
        if (found == -1) {
            return null;
        }
        int length = found - this.bufferIndex + 1;
        byte[] outgoing = new byte[length];
        System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
        this.bufferIndex = 0;
        this.bufferLast = 0;
        return outgoing;
    }

    public synchronized int readBytesUntil(int interesting, byte[] outgoing) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte what = (byte)interesting;
        int found = -1;
        for (int k = this.bufferIndex; k < this.bufferLast; ++k) {
            if (this.buffer[k] != what) continue;
            found = k;
            break;
        }
        if (found == -1) {
            return 0;
        }
        int length = found - this.bufferIndex + 1;
        if (length > outgoing.length) {
            System.err.println("readBytesUntil() byte buffer is too small for the " + length + " bytes up to and including char " + interesting);
            return -1;
        }
        System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
        this.bufferIndex += length;
        if (this.bufferIndex == this.bufferLast) {
            this.bufferIndex = 0;
            this.bufferLast = 0;
        }
        return length;
    }

    public synchronized String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public synchronized String readStringUntil(int interesting) {
        byte[] b = this.readBytesUntil(interesting);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    public void write(int what) {
        try {
            this.port.writeInt(what & 0xFF);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("write", e);
        }
    }

    public void write(byte[] bytes) {
        try {
            this.port.writeBytes(bytes);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("write", e);
        }
    }

    public void write(String what) {
        this.write(what.getBytes());
    }

    public void setDTR(boolean state) {
        try {
            this.port.setDTR(state);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("setDTR", e);
        }
    }

    public void setRTS(boolean state) {
        try {
            this.port.setRTS(state);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("setRTS", e);
        }
    }

    public static List<String> list() {
        return Arrays.asList(SerialPortList.getPortNames());
    }

    public static void errorMessage(String where, Throwable e) {
        System.err.println("Error inside Serial." + where + "()");
        e.printStackTrace();
    }
}

