/*
 * Decompiled with CFR 0.152.
 */
package CliTemplate;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.helpers.ProcessUtils;

public class ExecCommand
implements MessageConsumer {
    private boolean verbose = true;
    private boolean firstErrorFound;
    private boolean secondErrorFound;
    private RunnerException exception;

    public void execAsynchronously(String[] command) throws RunnerException {
        Process process;
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : command) {
            if ((string = string.trim()).length() == 0) continue;
            stringList.add(string);
        }
        command = stringList.toArray(new String[stringList.size()]);
        if (command.length == 0) {
            return;
        }
        int result = 0;
        if (this.verbose) {
            for (String c : command) {
                System.out.print(c + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = ProcessUtils.exec(command);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
        boolean compiling = true;
        while (compiling) {
            try {
                in.join();
                err.join();
                result = process.waitFor();
                compiling = false;
            }
            catch (InterruptedException ignored) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(MessageFormat.format("{0} returned {1}", command[0], result));
        }
        if (result != 0) {
            RunnerException re = new RunnerException(MessageFormat.format("exit code: {0}", result));
            re.hideStackTrace();
            throw re;
        }
    }

    @Override
    public void message(String s) {
        System.err.print(s);
    }
}

