@echo off
REM Author: Jiri Blazek (blazek@isn.cz)
REM Doc: https://www.fstimer.cz/wiki/doku.php?id=nahravani_softwaru_do_casomiry_-_treninkova_casomira

REM nastavit COM PORT!!! (napr. COM8)
REM set COM_Port=COM8
set COM_PORT=COM99

set HW_VERSION=1.0
set SW_VERSION=0.1.2

set ISERROR=false

echo.
echo Nahravani firmware do casomiry pro pozarni sport (https://www.fstimer.cz)
echo =========================================================================

echo.
if [%COM_PORT:] == [] (
  echo [WARN] Nejprve musite nastavit COM PORT pro komunikaci s mikropocitacem Maple Mini
  echo [WARN] Podrobny navod naleznete v README.TXT a README.PDF  
  set ISERROR=true
) else (
  echo [INFO] COM PORT pro komunikaci s mikropocitacem Maple Mini nastaven na %COM_PORT%
) 

if not exist .\firmware\HW-FST%HW_VERSION%\fs-hand-%SW_VERSION%.cpp.bin (
  echo [ERROR] Firmware SW %SW_VERSION% pro HW FST %HW_VERSION% nenalezen .\firmware\HW-FST%HW_VERSION%\fs-hand-%SW_VERSION%.cpp.bin
  set ISERROR=true
) else (
  echo [INFO] Firmware SW %SW_VERSION% pro HW FST %HW_VERSION% nalezen .\firmware\HW-FST%HW_VERSION%\fs-hand-%SW_VERSION%.cpp.bin
)

if %ISERROR% == false (
  echo [INFO] Start nahravani firmware
  echo.
  call .\upload\maple_upload.bat %COM_PORT% 1 1EAF:0003 ..\firmware\HW-FST%HW_VERSION%\fs-hand-%SW_VERSION%.cpp.bin
) 

echo.
pause