/*
 * Decompiled with CFR 0.152.
 */
package CliTemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;

public class DFUUploader
implements MessageConsumer {
    boolean firstErrorFound;
    boolean secondErrorFound;
    boolean notFoundError;
    boolean verbose;
    RunnerException exception;
    static final String SUPER_BADNESS = "Compiler error!";

    public boolean uploadUsingPreferences(String binPath, boolean verbose) throws RunnerException {
        this.verbose = verbose;
        return this.uploadViaDFU(binPath);
    }

    private boolean found_device(String dfuData, String usbID) {
        return dfuData.contains(("Found DFU: [0x" + usbID.substring(0, 4)).toUpperCase()) || dfuData.contains(("Found DFU: [" + usbID.substring(0, 4)).toUpperCase());
    }

    public boolean uploadViaDFU(String binPath) throws RunnerException {
        this.verbose = Preferences.getBoolean("upload.verbose");
        String fileType = "bin";
        if (fileType.equals("bin")) {
            String usbID = Preferences.get("upload.usbID");
            if (usbID == null) {
                usbID = Preferences.get("upload.usbID");
            }
            if (Preferences.get("upload.auto_reset") != null) {
                if (Preferences.get("upload.auto_reset").toLowerCase().equals("true")) {
                    System.out.println("Resetting to bootloader via DTR pulse");
                    this.emitResetPulse();
                }
            } else {
                System.out.println("Resetting to bootloader via DTR pulse");
                this.emitResetPulse();
            }
            String dfuList = new String();
            ArrayList<String> commandCheck = new ArrayList<String>();
            commandCheck.add("dfu-util");
            commandCheck.add("-l");
            long startChecking = System.currentTimeMillis();
            System.out.println("Searching for DFU device [" + usbID + "]...");
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!this.found_device((dfuList = this.executeCheckCommand(commandCheck)).toUpperCase(), usbID) && System.currentTimeMillis() - startChecking < 7000L);
            if (!this.found_device(dfuList.toUpperCase(), usbID)) {
                System.out.println(dfuList);
                System.err.println("Couldn't find the DFU device: [" + usbID + "]");
                return false;
            }
            System.out.println("Found it!");
            String altIf = Preferences.get("upload.altID");
            ArrayList<String> commandDownloader = new ArrayList<String>();
            commandDownloader.add("dfu-util");
            commandDownloader.add("-a " + altIf);
            commandDownloader.add("-R");
            commandDownloader.add("-d " + usbID);
            commandDownloader.add("-D" + binPath);
            return this.executeUploadCommand(commandDownloader);
        }
        System.err.println("Only .bin files are supported at this time");
        return false;
    }

    private void emitResetPulse() throws RunnerException {
        int programDelay = Preferences.getInteger("programDelay");
        try {
            Serial serialPort = new Serial();
            serialPort.setRTS(false);
            serialPort.setDTR(false);
            serialPort.setDTR(true);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            serialPort.setDTR(false);
            serialPort.setRTS(true);
            serialPort.setDTR(true);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            serialPort.setDTR(false);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            serialPort.write("1EAF");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            serialPort.dispose();
        }
        catch (Exception e) {
            System.err.println("Reset via USB Serial Failed! Did you select the right serial port?\nAssuming the board is in perpetual bootloader mode and continuing to attempt dfu programming...\n");
        }
    }

    protected String executeCheckCommand(Collection commandDownloader) throws RunnerException {
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        this.notFoundError = false;
        int result = 0;
        String userdir = System.getProperty("user.dir") + File.separator;
        String returnStr = new String();
        try {
            String s;
            String[] commandArray = new String[commandDownloader.size()];
            commandDownloader.toArray(commandArray);
            String armBasePath = "";
            commandArray[0] = armBasePath + commandArray[0];
            if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                for (int i = 0; i < commandArray.length; ++i) {
                    System.out.print(commandArray[i] + " ");
                }
                System.out.println();
            }
            Process process = Runtime.getRuntime().exec(commandArray);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            boolean busy = true;
            while (busy) {
                try {
                    result = process.waitFor();
                    busy = false;
                }
                catch (InterruptedException intExc) {}
            }
            while ((s = stdInput.readLine()) != null) {
                returnStr = returnStr + s + "\n";
            }
            process.destroy();
            if (this.exception != null) {
                this.exception.hideStackTrace();
                throw this.exception;
            }
            if (result != 0) {
                return "Error!";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result != 0 && result != 1) {
            this.exception = new RunnerException(SUPER_BADNESS);
        }
        return returnStr;
    }

    protected boolean executeUploadCommand(Collection commandDownloader) throws RunnerException {
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        this.notFoundError = false;
        int result = 0;
        String userdir = System.getProperty("user.dir") + File.separator;
        try {
            String[] commandArray = new String[commandDownloader.size()];
            commandDownloader.toArray(commandArray);
            String armBasePath = "";
            commandArray[0] = armBasePath + commandArray[0];
            if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                for (int i = 0; i < commandArray.length; ++i) {
                    System.out.print(commandArray[i] + " ");
                }
                System.out.println();
            }
            Process process = Runtime.getRuntime().exec(commandArray);
            new MessageSiphon(process.getInputStream(), this);
            new MessageSiphon(process.getErrorStream(), this);
            boolean compiling = true;
            while (compiling) {
                try {
                    result = process.waitFor();
                    compiling = false;
                }
                catch (InterruptedException intExc) {}
            }
            if (this.exception != null) {
                this.exception.hideStackTrace();
                throw this.exception;
            }
            if (result != 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result != 0 && result != 1) {
            this.exception = new RunnerException(SUPER_BADNESS);
        }
        return result == 0;
    }

    @Override
    public void message(String s) {
        if (s.indexOf("dfu-util - (C) ") != -1) {
            return;
        }
        if (s.indexOf("This program is Free Software and has ABSOLUTELY NO WARRANTY") != -1) {
            return;
        }
        if (s.indexOf("No DFU capable USB device found") != -1) {
            System.err.print(s);
            this.exception = new RunnerException("Problem uploading via dfu-util: No Maple found");
            return;
        }
        if (s.indexOf("Operation not perimitted") != -1) {
            System.err.print(s);
            this.exception = new RunnerException("Problem uploading via dfu-util: Insufficient privilages");
            return;
        }
        System.out.print(s);
    }
}

